/* SPDX-License-Identifier: GPL-2.0-only */
/* Copyright (C) 1999 - 2023 Intel Corporation */

#ifndef _KCOMPAT_DEFS_H_
#define _KCOMPAT_DEFS_H_

#ifndef LINUX_VERSION_CODE
#include <linux/version.h>
#else
#ifndef KERNEL_VERSION
#define KERNEL_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))
#endif
#endif /* LINUX_VERSION_CODE */

/*
 * Include the definitions file for HAVE/NEED flags for the standard upstream
 * kernels.
 *
 * Then, based on the distribution we detect, load the distribution specific
 * definitions file that customizes the definitions for the target
 * distribution.
 */

#if (defined(CONFIG_UOS_KERNEL) || defined(CONFIG_EULER_KERNEL) || defined(CONFIG_KYLIN_KERNEL))
#include "kcompat_chn_os.h"
#endif

#ifdef KCOM_GENERATED_DEF
#include "kcompat_generated_defs.h"
#endif

#endif /* _KCOMPAT_DEFS_H_ */
